#!/usr/bin/perl
#
# generateConnections.pl

use strict;
use Getopt::Long;
use Term::ReadKey;

my $infile 	= "./saplogon.ini";
my $outfile	= "./javagui_connections.txt";
my $option;
my %data;
my @connections;
my @javagui_connections;
my $snc_options;
my $router1;
my $router2;
my $line;
my $key;
my $overwrite;
my $version = 0.6;

Getopt::Long::Configure( 'no_ignore_case' );
Getopt::Long::Configure( 'bundling' );

my $options = GetOptions( 'w|wincon:s'			=>	\$infile,
													'j|javacon:s'			=>  \$outfile,
													'o|overwrite'			=>	\$overwrite,
													'h|help:s'				=>  sub { printhelp(); exit; },
													'v|version:s'			=>	sub { printversion(); exit; } );													

if ($overwrite != "1") {
	if (-e $outfile) {
		ReadMode('cbreak');
		print "The specified output file <" . $outfile . "> already exists. Do you want to overwrite it? [y/n]";
		$key = ReadKey(0);
		ReadMode('normal');
		if ($key  ne "y") {
			print "\nExiting...\n";
	   	exit;
		}
		else {
			print "\nOverwriting existing file...\n";
		}
	}
}

open(SAPLOGON,'<'.$infile) or die "Open $infile failed: $!";

while ($line = <SAPLOGON>)
{
	$line =~ s/(\015|\012)+$//;
	next if ($line =~ /^\s*#/);
	
	if ($line =~ /^\[(.*)\]$/) {
		$option = $1;
	}
	elsif ($line =~ /^\s*([^=]+?)\s*=\s*(.*\S)\s*$/) {
	  my ($key,$value) = ($1, $2);
	  $data { $option } { $key } = $value;
	}
}

close(SAPLOGON);

@connections = sort keys( %{ $data{'Description'} } );
 
foreach my $connection(@connections)
{
	if ( $data { 'SncChoice' }{ $connection } gt "0") {
		$snc_options = "&sncon=true&sncqop=" . $data { 'SncChoice' }{ $connection };
	}
	else {
		$snc_options = "";
	}
	if ( $data { 'Router' }{ $connection }) {
		$router1 = $data { 'Router' }{ $connection };
		$router1 =~ s/\/H\/$//;
	}
	else {
		undef $router1;
	}
	if ( $data { 'MSSrvName' }{ $connection } ) {
		my $javagui_connection = sprintf("%s:conn=%s/R/%s/G/%s%s", $data { 'Description' }{ $connection },
		                       																		$router1,
		                       																		$data { 'MSSysName' }{ $connection },
		                       																		$data { 'Server' }{ $connection },
		                       																		$snc_options);
		push (@javagui_connections, $javagui_connection);
	}
	else {
		my $javagui_connection = sprintf("%s:conn=%s/H/%s/S/32%02d%s", $data { 'Description' }{ $connection },
																																	$router1,
																																	$data { 'Server' }{ $connection },
																																	$data { 'Database' }{ $connection },
																																	$snc_options);
		push (@javagui_connections, $javagui_connection);
	}
}

open JAVAGUI_CONNECTIONS, ">$outfile" or die "Open $outfile failed: $!";
print JAVAGUI_CONNECTIONS join ("\n", @javagui_connections);
print JAVAGUI_CONNECTIONS "\n";
close JAVAGUI_CONNECTIONS;

sub printhelp {
	print "Syntax: generateConnections.pl [-w filename] [-j filename]\n";
	print "-w | --wincon:        <WinGUI saplogon.ini File>          (INPUT FILE,  default: ./saplogon.ini)\n";
	print "-j | --javacon:       <JavaGUI Connections File>          (OUTPUT FILE, default: ./javagui_connections.txt)\n";
	print "-o | --overwrite:     Overwrites an existing output file without prompting.\n";	
	print "-h | --help:          Prints this help text.\n";
	print "-v | --version:       Prints the version of this script.\n";
}

sub printversion {
	print "Version: " . $version . "\n";
}